<?php
    /**
    *
    * copyright (c) 2013-2019 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    class VisualizzatoreContenutiGirevoli extends VisualizzatoreComponente {
        function __construct($db) {
            parent::__construct($db);
        }

        function generaContenutoSezione($dati) {
            $datiConfigurazione = parent::getDb()->leggiSingolaRiga("geec_contenutiGirevoli",$dati["idElemento"]);
            
            echo"<div class=\"{$datiConfigurazione["spazioOccupato"]}\">";
            $this->stampaDiv($dati,$datiConfigurazione);
            echo"</div>";
        }
        
        function stampaDiv($dati,$datiConfigurazione) {

                if($datiConfigurazione['mostraTitoloComponente']=="si") {
            ?>
                     <div class="row">
                        <div class="col-md-12 mb-3 text-center">
                            <h2 class="separatore-inferiore"><?php echo $datiConfigurazione["nome"] ?></h2>
                        </div>
                    </div>
            <?php
                }
            ?>
            <div class="row d-flex align-items-stretch griglia-immagini flip-cards">
            <?php 
                $query = "SELECT * FROM geec_singoliContenutiGirevoli WHERE idSezione = {$dati["idElemento"]} ORDER BY posizione ASC";
                $ris   = parent::getDb()->eseguiQueryLettura($query);
                while($contenuto = $ris->fetch_assoc()) {
                    $this->stampaSingoloDiv($contenuto,$datiConfigurazione["classeElementi"],$datiConfigurazione["aspectRatioElementi"],$datiConfigurazione["immaginiInBackground"]);
                }
            ?>    
            </div>
            <?php
        }
        
        function stampaSingoloDiv($elemento,$classe,$aspectRatio,$immaginiInBackground) {
            ?>
                <div class="<?php echo $classe." ".$elemento["classeElemento"] ?>">
                    <?php 
                        if($elemento["link"]!="") {
                            ?>
                            <a href="<?php echo $elemento["link"] ?>">
                            <?php
                        }
                        
                        $stringaTagStyle = ($immaginiInBackground=="si") ? "background: url('{$elemento["immagine"]}');" : "background: {$elemento["sfondoDivImmagine"]}"; 
                    ?>
                        <div class="flip-card mb-4">
                            <div class="flip-card-inner <?php echo $aspectRatio ?>">
                                <div class="flip-card-front d-flex align-items-center background-image text-<?php echo strtolower($elemento["coloreTestoDivImmagine"]) ?>" style="<?php echo $stringaTagStyle ?>">
                                    <div class="w-100">
                                        <?php                                    
                                            if($immaginiInBackground!="si") {
                                        ?>
                                            <img src="<?php echo $elemento["immagine"]; ?>" class="img-fluid">
                                        <?php
                                            }
                                            if($elemento["etichetta"]!="") {
                                                ?>
                                                <h6 class="text-center mt-3"><?php echo $elemento["etichetta"] ?></h6>
                                                <?php
                                            }
                                        ?>
                                    </div>
                                </div>
                                <div class="flip-card-back d-flex align-items-center text-<?php echo strtolower($elemento["coloreTestoDivTesto"]) ?>" style="background: <?php echo $elemento["sfondoDivTesto"]; ?>">
                                    <div class="p-4 w-100">
                                        <?php echo $elemento["testo"] ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php 
                        if($elemento["link"]!="") {
                            ?>
                            </a>
                            <?php
                        }
                    ?>
                </div>
            <?php
        }

    }